<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
add_toolbar_button(form_button("<i class='glyphicon glyphicon-plus'></i> " . __('New Category', 'portfolio'), array('onclick' => "window.location = '" . $_SERVER["REQUEST_URI"] . "&action=create'", 'class' => 'btn btn-primary')));
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Portfolio Categories','portfolio'); ?></h3>
    </div>
    <div class="panel-body">
                <div class="row">
                    <div class="col-md-8">
                        <div class="btn-group pull-left btnGroupBulkAction" id="action-box">
                            <button type="button" class="btn btn-default btn-md btn-flat dropdown-toggle" data-toggle="dropdown">
                                <?php echo __('Select Action','portfolio'); ?> <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu" role="menu" id="bulkAction">
                                <li><a href="#" onclick="confirmaction('delete')"><?php echo __('Delete','portfolio'); ?></a></li>
                                <li><a href="#" onclick="confirmaction('publish')"><?php echo __('Publish','portfolio'); ?></a></li>
                                <li><a href="#" onclick="confirmaction('unpublish')"><?php echo __('Unpublish','portfolio'); ?></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4 search-form">
                        <form name="search" method="get" action="" class="form-inline">
                            <div class="input-group">
                                <input type="hidden" name="admin-page" value="portfolio" />
                                <input type="hidden" name="sub_page" value="category" />
                               <input type="text" class="form-control" name="cat-name" placeholder='<?php echo __('Please enter category name','portfolio'); ?>'>
                               <span class="input-group-btn">
                                   <button class="btn btn-default" type="submit" id="btnSearch">
                                       <i class="fa fa-search"></i> <?php echo __('Search', 'portfolio') ?>
                                   </button>
                                   <a href="<?php echo admin_url(array('admin-page'=>'portfolio','sub_page'=>'category'), false); ?>" class="btn btn-default btn-flat"> 
                                        <i class="fa fa-times-circle"></i>
                                    </a>
                               </span>
                           </div>
                           </form>
                    </div>
                </div>
                <div class="row padding-10-0">
                    <div class="col-sm-3">

                    </div>
                    <div class="col-sm-9">
                        <!-- Pagination -->
                        <?php echo $pages->short_page_link();?>					<!-- Pagination -->
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <form method=post action='' id='checkform'>
                         <input type="hidden" id='action' name="action" />
                        <div class="table-responsive">
                            <table class="bootstrap-table">
                                <thead>
                                    <tr>
                                        <th data-fixed="left"><label><input type='checkbox' id='checkall' name='checkall' /> </label></th>
                                        <th class="width300"><?php echo __('Category name', 'portfolio'); ?></th>
                                        <th class="width200"><?php echo __('Shortcode', 'portfolio'); ?></th>
                                        <th class="width400"><?php echo __('Description', 'portfolio'); ?></th>
                                        <th class="width80"><?php echo __('Status', 'portfolio'); ?></th>
                                        <th data-fixed="right" class="width150 center"><?php echo __('Actions', 'portfolio'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($list as $item) {?>
                                    <tr>
                                        <td> <input type='checkbox' name='cid[]' value=' <?php echo $item['category_id']; ?> ' class='checkbox' /></td>
                                        <td><?php echo $item['category_name'] ?></td>
                                        <td>{pf:portfolio catid=<?php echo  $item['category_id'];?>}</td>
                                        <td><?php echo $item['category_description'] ?></td>
                                        <td><?php
                                        switch ($item['category_status']) {
                                                            case '1':
                                                                echo "<a href='" . admin_url("admin-page=portfolio&sub_page=category&do=unpublish&id=" . $item['category_id']) . "' class='label label-success'>" . __("Published", 'portfolio') . "</a>";
                                                                break;
                                                            default:
                                                                echo "<a href='" . admin_url("admin-page=portfolio&sub_page=category&do=publish&id=" . $item['category_id']) . "' class='label label-danger'>" . __("Unpublished", 'portfolio') . "</a>";
                                                                break;
                                                        }
                                        ?></td>
                                        <td>
                                            <a class="btn btn-info btn-xs" href="<?php echo admin_url('action=edit&id='.$item['category_id']); ?>">
                                                <i class="fa fa-pencil-square-o"></i> <?php echo __('Edit', 'portfolio'); ?>
                                            </a> 
                                            <a class="btn btn-danger btn-xs" onclick="delete_menu('<?php echo admin_url('action=delete&id='.$item['category_id']);?>');return;">
                                                <i class="fa fa-times-circle"></i> <?php echo __('Delete', 'portfolio'); ?>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        </form>
                    </div>
                </div>

            </div>
    <div class="panel-footer">
        <div class="row">
            <div class="col-sm-6">
                <?php echo $pages->page_lable(); ?>
            </div>
            <div class="col-sm-6">
                <!-- Pagination -->
                <?php echo $pages->page_links($org_url . '&'); ?>
                <!-- Pagination -->
            </div>
        </div>
    </div>
</div>
<script>
    function delete_menu(url) {
        $.sModal({
            image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
            content: '<?php echo __('If you delete this category, all the portfolio belongs to it will be deleted also. Are you sure?', 'portfolio'); ?>',
            animate: 'fadeDown',
            buttons: [
                {
                    text: '<i class="fa fa-times-circle"></i> <?php echo __('Delete', 'portfolio'); ?> ',
                    addClass: 'btn-danger',
                    click: function(id, data) {
                        window.location = url;
                        $.sModal('close', id);
                    }
                },
                {
                    text: ' <?php echo __('Cancel', 'portfolio'); ?> ',
                    click: function(id, data) {
                        $.sModal('close', id);
                    }
                },
            ]
        });
    }
   
function confirmaction(act) {
    if(act  ==   'delete'){
        txtConfirm =   '<?php echo __('If you delete this category, all the portfolio belongs to it will be deleted also. Are you sure?', 'portfolio'); ?>';
        }
        else {
            txtConfirm =   '<?php echo __('Are you sure with this action?', 'portfolio'); ?>';
        }
    $.sModal({
                image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
                content: txtConfirm,
                animate: 'fadeDown',
                buttons: [
                    {
                        text: '<i class="fa fa-times-circle"></i> <?php echo __('Confirm', 'portfolio'); ?> ',
                        addClass: 'btn-danger',
                        click: function(id, data) {
                           $('#action').val(act);
                           $('#checkform').submit();
                            $.sModal('close', id);
                        }
                    },
                    {
                        text: ' <?php echo __('Cancel', 'portfolio'); ?> ',
                        click: function(id, data) {
                            $.sModal('close', id);
                        }
                    },
                ]
            });
}
</script>